package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.clx.performance.dao.collect.CollectDriverTransportIntentionRecordDao;
import com.clx.performance.mapper.collect.CollectDriverTransportIntentionRecordMapper;
import com.clx.performance.model.collect.CollectDriverTransportIntentionRecord;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 16:26
 */
@Repository
public class CollectDriverTransportIntentionRecordDaoImpl extends BaseDaoImpl<CollectDriverTransportIntentionRecordMapper, CollectDriverTransportIntentionRecord, Integer> implements CollectDriverTransportIntentionRecordDao {

    @Override
    public LocalDateTime getLastUpdateTime() {
        LambdaQueryWrapper<CollectDriverTransportIntentionRecord> query = new LambdaQueryWrapper<>();
        query.select(CollectDriverTransportIntentionRecord::getModifiedTime);
        query.orderByDesc(CollectDriverTransportIntentionRecord::getModifiedTime);
        query.last("limit 1");
        return baseMapper.selectOne(query).getModifiedTime();
    }
}
