package com.clx.performance.controller.pc.carrier;

import com.clx.performance.param.pc.carrier.SavePlatformServiceFeeConfigParam;
import com.clx.performance.service.PlatformServiceFeeConfigService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePlatformServiceFeeConfigVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;

/**
 * @author yangqifa
 */
@Slf4j
@RestController
@RequestMapping(value = "/pc/carrier/platformServiceFeeConfig")
@Validated
@Tag(name = "承运端-平台费率配置")
@AllArgsConstructor
public class PlatformServiceFeeConfigController {

    private final PlatformServiceFeeConfigService platformServiceFeeConfigService;

    @Operation(summary = "平台费率配置列表", description = "<br>By:杨启发")
    @GetMapping("/listPlatformServiceFeeConfig")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformServiceFeeConfigVO> listPlatformServiceFeeConfig() {
        return Result.ok(platformServiceFeeConfigService.listPlatformServiceFeeConfig());
    }

    @Operation(summary = "平台费率配置详情", description = "<br>By:杨启发")
    @GetMapping("/getPlatformServiceFeeConfigDetail")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformServiceFeeConfigVO> getPlatformServiceFeeConfigDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(platformServiceFeeConfigService.getPlatformServiceFeeConfigDetail(id));
    }

    @Operation(summary = "编辑平台费率配置", description = "<br>By:杨启发")
    @PostMapping("/updatePlatformServiceFeeConfig")
    @UnitCovert
    public Result updatePlatformServiceFeeConfig(@RequestBody @Validated SavePlatformServiceFeeConfigParam param) {
        platformServiceFeeConfigService.updatePlatformServiceFeeConfig(param);
        return Result.ok();
    }

}
