package com.clx.performance.controller.feign;

import com.clx.open.sdk.request.dto.OwnerCancelResidueWeightDTO;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.service.OrderGoodsService;
import com.msl.common.result.Result;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

@Slf4j
@RestController
@RequestMapping("/feign/sdk")
@Validated
@Api(tags = "对外sdk Feign")
@AllArgsConstructor
public class PerformanceSdkFeignController {


    private final OrderCancelService orderCancelService;

    private final OrderGoodsService orderGoodsService;


    @ApiOperation(value = "货主端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/ownCancelOrderPre")
    public Result<Object> ownCancelOrderPre(@RequestBody OrderCancelParam param) {
        log.info("取消订单参数：{}", TokenUtil.getLoginUserInfo());
        orderCancelService.ownerCancelOrderPre(param);
        return Result.ok();
    }

    @ApiOperation(value = "获取当前订单可取消吨数", notes = "<br>By:胡宇帆")
    @GetMapping("/orderCancelResidueWeight")
    public Result<OwnerCancelResidueWeightDTO> orderCancelResidueWeight(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "optionType") String optionType) {
        log.info("当前订单可取消吨数参数：{}", TokenUtil.getLoginUserInfo());
        OwnerCancelResidueWeightDTO dto = new OwnerCancelResidueWeightDTO();
        dto.setWeight(orderGoodsService.orderCancelResidueWeight(orderNo, optionType).toString());
        return Result.ok(dto);
    }
}
