package com.clx.performance.feign;

import com.clx.open.sdk.request.dto.OwnerCancelResidueWeightDTO;
import com.clx.performance.param.pc.OrderCancelParam;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "clx-performance", configuration = PerformanceClientConfiguration.class)
public interface PerformanceSDKFeign {


    @PostMapping(value = {"clx-performance/feign/sdk/ownCancelOrderPre"})
    Result<String> ownCancelOrderPre(@RequestBody OrderCancelParam param);


    @GetMapping(value = {"clx-performance/feign/sdk/orderCancelResidueWeight"})
    Result<OwnerCancelResidueWeightDTO> orderCancelResidueWeight(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "optionType") String optionType);

}
