package com.clx.performance.vo.pc;

import com.clx.performance.enums.OrderChildEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildOperateRecordVO {

    @Schema(description = "运单编号", example = "100000000")
    private String childNo;

    @Schema(description = "操作类型 1 取消运单 2 解除装车限制", example = "1")
    private Integer type;

    @Schema(description = "主车牌照", example = "京A12345")
    private String truckNo;

    @Schema(description = "司机名称", example = "张三")
    private String driverName;

    @Schema(description = "联系方式", example = "130000000")
    private String driverMobile;

    @Schema(description = "货源地", example = "朝阳")
    private String sendAddress;

    @Schema(description = "目的地", example = "西城")
    private String receiveAddress;

    @Schema(description = "货物类型名称", example = "面煤")
    public String goodTypeName;

    @Schema(description = "备注", example = "备注xxxx")
    public String remark;

    @Schema(description = "操作时间", example = "2020-01-01 10:10:10")
    public String operateTime;

    @Schema(description = "操作人", example = "张三")
    public String operator;

    @Schema(description = "操作类型  取消运单  解除装车限制", example = "取消运单")
    public String getTypeMsg() {
        return OrderChildEnum.OperateRecordType.getMsgByCode(type);
    }

}