package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


@Getter
@AllArgsConstructor
public enum SyncPlatformEnum {

    ;
    @Getter
    @AllArgsConstructor
    public enum Source {
        TRADE_PLATFORM(1, "数煤宝"),
        OWNER_PLATFORM(2, "承运货主"),
        NEW_OWNER_CLIENT(3, "供应链"),
        ;
        private final Integer code;
        private final String name;


        public static Optional<Source> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code,code)).findFirst();
        }

        public static String getNameByCode(Integer code) {
            if (code == null) {return null;}
            return getByCode(code).map(Source::getName).orElse(null);
        }
    }
}
