package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-22
 * Time 11:08
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_exception_report_deal_log")
public class OrderChildExceptionReportDealLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("report_no")
    @Schema(description="异常上报编号")
    private String reportNo;

    @TableField("deal_way")
    @Schema(description="处理方式  1:同意扣罚  2：申诉")
    private Integer dealWay;

    @TableField("appeal_reason")
    @Schema(description="申诉原因")
    private String appealReason;

    @TableField("picture_url")
    @Schema(description="图片")
    private String pictureUrl;

    @TableField("video_url")
    @Schema(description="视频")
    private String videoUrl;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
