package com.clx.performance.listener.broker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBrokerConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 无车承运 mq
 * @Date: 2023-10-20 16:14:30
 * @Version: 1.0
 */
@Slf4j
@Component
public class BrokerDelayListener {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @RabbitListener(queues = RabbitKeyBrokerConstants.DEFAULT_DEAD_QUEUE)
    public void process(Message message) {
        try{
            log.info("无车承运-延迟, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<MqDelay>>(){}).getData());
        }catch (Exception e){
            log.info("无车承运-延迟 失败",e);
        }
    }

    void process(MqDelay mq){
        Message message = MessageBuilder.withBody(JSON.toJSONString(mq.getData()).getBytes()).build();
        rabbitTemplate.send(mq.getExchange(), mq.getRouterKey(), message);
    }

}
