package com.clx.performance.listener.settle;

import com.alibaba.fastjson.JSON;
import com.clx.open.sdk.callback.OpenCallBackClient;
import com.clx.open.sdk.callback.message.SettlementOwnerBillMessage;
import com.clx.order.enums.SyncPlatformEnum;
import com.clx.performance.config.ThirdAppConfig;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.dto.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.msl.common.result.Result;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Component
@AllArgsConstructor
public class SettlementOwnerDtsListener {

    private final ThirdAppConfig thirdAppConfig;

    private final SettlementOwnerDetailDao settlementOwnerDetailDao;



    @RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_SETTLEMENT_OWNER_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.settlement_owner, msg:{}", msg);
            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);
            log.info("DTS消息同步开始, database:clx_performance.settlement_owner, 实体:{}", dataTransportDTO);
            log.info("操作类型：{}",dataTransportDTO.getOperationType().getCode());
            SettlementOwnerBillMessage before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new SettlementOwnerBillMessage());
            SettlementOwnerBillMessage after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new SettlementOwnerBillMessage());
            List<SettlementOwnerDetail> settlementOwnerDetails = settlementOwnerDetailDao.getBySettlementNo(after.getSettlementNo());
            after.setChildNos(settlementOwnerDetails.stream().map(SettlementOwnerDetail::getChildNo).collect(Collectors.toList()));
            if(Objects.equals(DtsOperationTypeEnum.DELETE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                log.info("删除:{}",before);
                return;
            }
            //违约结算单数据同步
            thirdpartySync(after);
        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.settlement_owner_detail, error:{}", e.getMessage());
        }
    }


    /**
     * 第三方同步
     */
    public void thirdpartySync(SettlementOwnerBillMessage message){

        try{
            OpenCallBackClient openCallBackClient = thirdAppConfig.getOpenCallBackClient(SyncPlatformEnum.Source.NEW_OWNER_CLIENT.getCode().toString());
            log.info("货主结算单同步:{}", message.getId());
            Result<?> result = openCallBackClient.encryptPost(JSON.toJSONString(message), message.topic());
            if (result.succeed()) {
                log.info("货主结算单同步成功:{}", message.getId());


            }else{
                log.info("货主结算单同步失败:{}", message.getId());
            }

        }catch (Exception e){

        }

    }

}
