package com.clx.performance.listener;

import cn.hutool.json.JSONUtil;
import com.clx.open.sdk.callback.message.OrderInfoMessage;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.service.PerformanceProgressService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SyncPerformanceProgress4OrderInfoListener {

    private final PerformanceProgressService performanceProgressService;


    @RabbitListener(queues = RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_INFO_QUEUE)
    public void onMessage(String message) {
        log.info("监听到同步履约进度表---订单信息部分,消息内容{}", message);
        OrderInfoMessage data = JSONUtil.toBean(message, OrderInfoMessage.class);
        performanceProgressService.dealPerformanceProgress4OrderInfo(data);
    }
}
