package com.clx.performance.listener;

import cn.hutool.json.JSONUtil;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.model.OrderGoodsAdjustmentPrice;
import com.clx.performance.service.OrderGoodsAdjustmentPriceService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SaveOrderGoodsAdjustmentPriceListener {

    private final OrderGoodsAdjustmentPriceService orderGoodsAdjustmentPriceService;


    @RabbitListener(queues = RabbitKeyConstants.SAVE_ORDER_GOODS_ADJUSTMENT_PRICE_QUEUE)
    public void onMessage(String message) {
        log.info("监听到保存货单挂单运费调整记录,消息内容{}", message);
        OrderGoodsAdjustmentPrice data = JSONUtil.toBean(message, OrderGoodsAdjustmentPrice.class);
        orderGoodsAdjustmentPriceService.saveOrderGoodsAdjustmentPrice(data);
    }
}
