package com.clx.performance.service.impl;

import com.clx.performance.enums.InputOutputEnum;
import com.clx.performance.enums.SaleBuyEnum;
import com.clx.performance.param.app.OrderChildWeighPictureParam;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.OrderChildWeighPictureService;
import com.clx.performance.vo.app.PictureVo;
import com.smart.business.sdk.request.dto.WeightChildSignatureDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author liruixin
 * Date 2024-08-02
 * Time 15:38
 */
@Service
public class OrderChildWeighPictureServiceImpl  implements OrderChildWeighPictureService {

    @Autowired
    private OrderChildService orderChildService;

    @Override
    public PictureVo getWeighPictures(OrderChildWeighPictureParam param) {
        //电子磅单图片
        WeightChildSignatureDto unloadImages = orderChildService.getWeighingSignature(param.getChildNo(), SaleBuyEnum.Type.BUY.getCode());
        PictureVo vo = new PictureVo();

        if (Objects.nonNull(unloadImages) && CollectionUtils.isNotEmpty(unloadImages.getWeighingSignatureList())){
            vo.setUnloadImages(unloadImages.getWeighingSignatureList().stream().filter(
                    item -> Objects.equals(item.getType(), InputOutputEnum.Type.OUTPUT.getCode())).map(
                    item -> StringUtils.isNotBlank(item.getSignImg())? item.getSignImg():item.getOriginalImg()).collect(Collectors.toList()));
        }

        return vo;
    }
}
