package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.open.sdk.callback.message.OrderInfoMessage;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.service.PerformanceProgressService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SyncPerformanceProgress4OrderInfoListener {

    private final PerformanceProgressService performanceProgressService;


    @RabbitListener(queues = RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_INFO_QUEUE)
    public void onMessage(Message message) {
        try{
            log.info("监听到同步履约进度表---订单信息部分,消息内容{}", new String(message.getBody()));
            OrderInfoMessage data = JSON.parseObject(new String(message.getBody()),
                    new TypeReference<MqWrapper<OrderInfoMessage>>() {
                    }).getData();
            performanceProgressService.dealPerformanceProgress4OrderInfo(data);
        }catch (Exception e){
            log.info("监听到同步履约进度表---订单信息部分发生异常，异常原因：{}", ExceptionUtils.getStackTrace(e));
        }
    }
}
