package com.clx.performance.job.vehiclewarn;

import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.dao.vehiclewarn.VehicleWarnInfoDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnInfoEnum;
import com.clx.performance.model.vehiclewarn.VehicleWarnChild;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.service.vehiclewarn.VehicleWarnMqService;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Component
public class VehicleWarnJob {

    @Autowired
    private VehicleWarnChildDao vehicleWarnChildDao;
    @Autowired
    private VehicleWarnMqService vehicleWarnMqService;
    @Autowired
    private VehicleWarnInfoDao vehicleWarnInfoDao;

    /**
     * 车辆监控预警
     */
    @XxlJob("vehicleWarnTruckWarn")
    public void vehicleWarnTruckWarn() {

        try {

            List<VehicleWarnChild> list = vehicleWarnChildDao.ListTruckNoOfWarn();
            log.info("车辆监控预警, size:{}", list.size());

            for (VehicleWarnChild item : list) {

                // 发送mq (车辆预警)
                vehicleWarnMqService.truckWarn(item.getChildNo());
            }

        } catch (Exception e) {
            log.warn("车辆监控预警失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("车辆监控预警失败，异常原因=====================", e);
        }

    }

}
