package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildLoadParam extends PositionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "2.46")
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;

    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;

    @ApiModelProperty(value = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> loadImageList;

    @ApiModelProperty(value = "装货时间")
    private String loadTime;
}
