package com.clx.performance.service.settle;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PagePendingCarrierSettlementOwnerDetailParam;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePendingSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
public interface SettlementOwnerDetailService  {

    Integer saveSettlementDetail(OrderChild orderChild, OrderGoods orderGoods);

    IPage<PageOwnerSettlementOwnerDetailVO> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param);

    IPage<CarrierPageSettlementOwnerDetailVO> pageSettlementOwnerDetail(PageCarrierSettlementOwnerDetailParam param);

    SXSSFWorkbook exportOwnerSettlementOrderDetail(PageOwnerSettlementOwnerDetailParam param);

    Integer getInvoiceType(String orderNo);

    Boolean thawAndLockSettlement(String orderNo);

    IPage<CarrierPagePendingSettlementOwnerDetailVO> pagePendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param);

    SXSSFWorkbook exportPendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param);
}
