package com.clx.performance.extranal.user.impl;

import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderInfoVO;
import com.clx.performance.extranal.user.OrderService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
@AllArgsConstructor
public class OrderServiceImpl implements OrderService {

    private final OrderFeign orderFeign;

    @Override
    public Optional<FeignOrderInfoVO> getOrderInfo(String orderNo) {
        return Optional.ofNullable(orderFeign.getOrderInfo(orderNo))
                .filter(Result::succeed)
                .map(Result::getData);
    }

    @Override
    public Optional<List<String>> getMonthSameLineOrderList(String orderNo) {
        return Optional.ofNullable(orderFeign.getMonthSameLineOrderList(orderNo))
                .filter(Result::succeed)
                .map(Result::getData);
    }
}
