package com.clx.performance.controller.pc;

import com.clx.performance.service.LastTruckService;
import com.clx.performance.vo.app.OrderChildVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * @ClassName OrderWeightController
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:45
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/pc/lastTruck")
@Validated
@Api(tags = "最后一车")
@AllArgsConstructor
public class LastTruckController {

    private final LastTruckService lastTruckService;


    @ApiOperation(value = "查询订单下的最后一车",notes = "<br>By:刘海泉")
    @GetMapping("/getOrderLastTruck")
    public Result<OrderChildVO> getOrderLastTruck(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) throws Exception{
        return Result.ok(lastTruckService.getOrderLastTruck(orderNo));
    }



}
