package com.clx.performance.vo.pc.owner.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageOwnerSettlementOwnerDetailVO {

    @ApiModelProperty(value="货主用户编号",example = "4174174")
    private Long ownerUserNo;

    @ApiModelProperty(value="货主名称",example = "张三")
    private String ownerName;

    @ApiModelProperty(value="结算单号",example = "41441")
    private String settlementNo;

    @ApiModelProperty(value="结算子单号",example = "41441")
    private String settlementSubNo;

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;


    @ApiModelProperty(value="订单编号",example = "41441")
    private String orderNo;


    @ApiModelProperty(value="货物名称",example = "货物名称")
    private String goodsName;

    @MoneyOutConvert
    @ApiModelProperty(value="平台运费单价",example = "10.2")
    private BigDecimal freightPrice;

    @ApiModelProperty(value="实际净重（吨）",example = "2.3")
    private BigDecimal weight;


    @ApiModelProperty(value = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @MoneyOutConvert
    @ApiModelProperty(value="实际运费",example = "2.52")
    private BigDecimal freight;

    @MoneyOutConvert
    @ApiModelProperty(value="损耗单价",example = "1.2")
    private BigDecimal lossPrice;

    @ApiModelProperty(value="货损吨数（吨）",example = "1.02")
    private BigDecimal lossWeight;

    @MoneyOutConvert
    @ApiModelProperty(value="货损金额",example = "2.3")
    private BigDecimal lossFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="预付运费金额",example = "1.2")
    private BigDecimal prepayFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="结算金额",example = "1.2")
    private BigDecimal settlementFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="借款抵扣金额",example = "1.2")
    private BigDecimal loanFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="开票金额",example = "2.1")
    private BigDecimal invoiceFreight;

    @ApiModelProperty(value="开票标识：1网运单 2普通单",example = "普通单")
    private String invoiceTypeMsg;

    @MoneyOutConvert
    @ApiModelProperty(value="开票服务费",example = "2.1")
    private BigDecimal invoiceServiceFee;
    @ApiModelProperty(value="开票费率%",example = "12.34")
    private BigDecimal invoiceServiceFeeRate;

    @ApiModelProperty(value="尾款状态 0-否,1-是,2-无需支付",example = "无需支付")
    private String finalPaymentStatusMsg;

    @ApiModelProperty(value="开票状态 0-否,1-是",example = "是")
    private String invoiceStatusMsg;

    @ApiModelProperty(value="结算方式  1装车净重 2卸车净重 3卸车净重（减货损）",example = "1")
    private Integer settlementWay;


    @ApiModelProperty(value="开票公司id",example = "1")
    private Integer invoicingCompanyId;  //开票公司id
    @ApiModelProperty(value="开票公司简称",example = "1")
    private String invoicingCompanyShorterName; //开票公司简称
    @ApiModelProperty(value="开票公司统一社会信用代码",example = "1")
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    @ApiModelProperty(value="是否上报 0-否;1-是",example = "1")
    private Integer reportFlag;  //是否上报 0-否;1-是

    @ApiModelProperty(value="创建时间",example = "2013-01-01 00:00:00")
    private String createTime;

}