package com.clx.performance.sqlProvider.loan;

import cn.hutool.core.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OwnerLoanAccountSqlProvider {

    public String getOwnerLoanAccountByOwnerUserId(@Param("param") Long ownerUserNo) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type, " +
                    " a.funding_amount,a.virtually_amount,a.funding_arrears,a.virtually_arrears,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_loan_account a");

            if (ObjectUtil.isNotNull(ownerUserNo)) {
                WHERE("a.owner_user_no = #{ownerUserNo}");
            }

            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }



}
