package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.loan.OwnerLoanAccountDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.struct.loan.OwnerLoanAccountStruct;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerLoanAccountServiceImpl  implements OwnerLoanAccountService {

    private final OwnerLoanAccountDao ownerLoanAccountDao;

    private final OwnerLoanAccountStruct ownerLoanAccountStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void openOwnerLoanAccount(Long ownerUserNo, String ownerUserName, String mobile) {
        OwnerLoanAccount entity = new OwnerLoanAccount();
        entity.setOwnerUserNo(ownerUserNo);
        entity.setMobile(mobile);
        entity.setOwnerUserName(ownerUserName);
        entity.setFundingAmount(BigDecimal.ZERO);
        entity.setFundingAmount(BigDecimal.ZERO);
        entity.setVirtuallyAmount(BigDecimal.ZERO);
        entity.setVirtuallyArrears(BigDecimal.ZERO);
        ownerLoanAccountDao.saveEntity(entity);
    }

    @Override
    public IPage<OwnerLoanAccountVO> pageOwnerLoanAccount(PageOwnerLoanAccountParam param) {
        return ownerLoanAccountDao.pageByParam(param);
    }

    @Override
    public OwnerLoanAccountVO getOwnerLoanAccount() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        OwnerLoanAccount ownerLoanAccount  = ownerLoanAccountDao.getOneByField(OwnerLoanAccount :: getOwnerUserNo,loginUserInfo.getUserNo()).orElseThrow(
                PerformanceResultEnum.DATA_NOT_FIND);
        return  ownerLoanAccountStruct.convertVO(ownerLoanAccount);
    }
}
