package com.clx.performance.service.impl;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.mq.OrderChildCancelMqParam;
import com.clx.performance.service.OrderChildMqHandlerService;
import com.clx.performance.vo.mq.OrderChildAddMqParam;
import com.clx.performance.vo.mq.OrderChildArriveReceiveAddressMqParam;
import com.clx.performance.vo.mq.OrderChildArriveSendAddressMqParam;
import com.clx.performance.vo.mq.OrderChildDriverConfirmMqParam;
import com.clx.performance.vo.mq.OrderChildLoadMqParam;
import com.clx.performance.vo.mq.OrderChildUnloadMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class OrderChildMqHandlerServiceImpl implements OrderChildMqHandlerService {

    @Autowired
    private OrderChildDao orderChildDao;

    @Override
    public void orderChildAdd(OrderChildAddMqParam mq) {
        OrderChild orderChild = orderChildDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

    }

    @Override
    public void orderChildArriveSendAddress(OrderChildArriveSendAddressMqParam mq) {
        OrderChild orderChild = orderChildDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

    }

    @Override
    public void orderChildArriveReceiveAddress(OrderChildArriveReceiveAddressMqParam mq) {
        OrderChild orderChild = orderChildDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

    }

    @Override
    public void orderChildDriverConfirm(OrderChildDriverConfirmMqParam mq) {
        OrderChild orderChild = orderChildDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

    }

    @Override
    public void orderChildCancel(OrderChildCancelMqParam mq) {
        OrderChild orderChild = orderChildDao.getByChildNo(mq.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

    }

    @Override
    public void orderChildLoad(OrderChildLoadMqParam mq) {

    }

    @Override
    public void orderChildUnload(OrderChildUnloadMqParam mq) {

    }


}
