package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.order.enums.ResultEnum;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dto.zjxl.TruckCoordinateDTO;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.pc.GoodsOrderMapParam;
import com.clx.performance.service.GoodsOrderMapService;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.TruckService;
import com.clx.performance.vo.pc.Freight;
import com.clx.performance.vo.pc.GoodsOrderSendAddressSelect;
import com.clx.performance.vo.pc.TruckCoordinateVO;
import com.clx.user.feign.UserClxFeign;
import com.clx.user.vo.feign.TruckDetailInfoVO;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @ClassName GoodsOrderMapServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/10/10 10:42
 * @Version 1.0
 */
@Slf4j
@Service
public class GoodsOrderMapServiceImpl implements GoodsOrderMapService {

    @Autowired
    OrderGoodsDao goodsDao;

    @Autowired
    TruckService truckService;

    @Autowired
    OrderChildService orderChildService;

    @Autowired(required = false)
    UserClxFeign userClxFeign;



    @Override
    public List<GoodsOrderSendAddressSelect> getSendAddressSelect(GoodsOrderMapParam param) {
        List<OrderGoods> list = goodsDao.getSendAddressSelect(param);
        Map<String,GoodsOrderSendAddressSelect> noRepeatMap = new HashMap<>();

        List<GoodsOrderSendAddressSelect>  result = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            list.stream().forEach(item->{
                if(noRepeatMap.containsKey(item.getOrderNo())){
                    GoodsOrderSendAddressSelect select = noRepeatMap.get(item.getOrderNo());
                    Freight freight = Freight.builder().orderGoodsNo(item.getOrderGoodsNo()).pendingOrderFreight(
                            item.getPendingOrderFreight()).build();
                    select.getFreightList().add(freight);
                }else{
                    Freight freight = Freight.builder().orderGoodsNo(item.getOrderGoodsNo()).pendingOrderFreight(
                            item.getPendingOrderFreight()).build();
                    List<Freight> freightList = new ArrayList<>();
                    freightList.add(freight);
                    GoodsOrderSendAddressSelect select = GoodsOrderSendAddressSelect.builder().orderNo(
                            item.getOrderNo()).sendAddressId(item.getSendAddressId()).sendAddressShorter(
                            item.getSendAddressShorter()).sendLatitude(item.getSendLatitude()).sendLongitude(
                            item.getSendLongitude()).freightList(freightList).build();
                    noRepeatMap.put(item.getOrderNo(),select);
                }
            });
        }
        List<GoodsOrderSendAddressSelect> values = new ArrayList<>(noRepeatMap.values());
        return values;
    }

    @Override
    public List<String> getOrderChildTruckByOrderNo(String orderNo) {
        return orderChildService.getOrderChildTruckByOrderNo(orderNo);
    }

    @Override
    public List<TruckCoordinateVO> getPlatformTruckCoordinate() {
        List<TruckCoordinateVO> result = new ArrayList<>();
        Map<String, TruckDetailInfoVO> truckInfoMap = getTruckInfoMap();

        List<TruckCoordinateDTO> allTruckCoordinate = truckService.getAllTruckCoordinate();

        for(TruckCoordinateDTO item : allTruckCoordinate){
            String truckNo = item.getTruckNo();
            String name = Objects.nonNull(truckInfoMap.get(truckNo))?truckInfoMap.get(truckNo).getName():null;
            String mobile = Objects.nonNull(truckInfoMap.get(truckNo))?truckInfoMap.get(truckNo).getMobile():null;
            Integer truckUseStatus = Objects.nonNull(truckInfoMap.get(truckNo))?truckInfoMap.get(truckNo).getTruckOrderStatus():null;

            TruckCoordinateVO vo =  TruckCoordinateVO.builder().truckNo(item.getTruckNo()).longitudeX(item.getLongitudeX())
                    .latitudeY(item.getLatitudeY()).name(name).mobile(mobile).truckUseStatus(truckUseStatus).build();
            result.add(vo);
        }
        return result;
    }



    /**
     * @Author kavin
     * @Description 获取平台用车状态信息
     * @Param []
     * @return
     **/
    private Map<String,TruckDetailInfoVO> getTruckInfoMap(){
        //查询平台所有车辆的出车状态信息
        Result<List<TruckDetailInfoVO>> result = userClxFeign.getPlatformTruckInfo();
        log.info("通过clx-user服务获取平台认证成功车辆出车状态列表，返回结果:{}", JSON.toJSONString(result));

        if(!Objects.equals(result.getCode(), ResultCodeEnum.SUCCESS.getCode())){
            throw new ServiceSystemException(ResultEnum.DATA_NOT_FIND,"查询车辆详细信息失败");
        }

        Map<String,TruckDetailInfoVO> truckStatusMap = new HashMap<>();
        result.getData().stream().forEach(item->{
            truckStatusMap.put(item.getTruckNo(),item);
        });
        return truckStatusMap;
    }

}
