package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 借出方
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class Borrower implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String name;                            //借出方
    private String bankName;                        //所属银行
    private String bankCardNo;                      //银行账号
    private Integer deleteStatus;                   //删除状态: 0-否;1-是
    private Integer status;                         //状态：1启用 2禁用
    private Long opUserNo;                          //操作人编码
    private String opUserName;                      //操作人
    private LocalDateTime opTime;                   //操作时间
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}