package com.clx.performance.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @ClassName OwnerLoanAccountRunWaterRecordDTO
 * @Description
 * @Author kavin
 * @Date 2024/1/23 14:05
 * @Version 1.0
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class OwnerLoanAccountRunWaterRecordDTO {

    @ExcelProperty("货主编码")
    private String ownerUserNo;

    @ExcelProperty("货主名称")
    private String ownerUserName;

    @ExcelProperty("联系电话")
    private String mobile;

    @ExcelProperty("流水号")
    private Long runningWaterNo;

    @ExcelProperty("借款单号")
    private Long loanNo;

    @ExcelProperty("运单编号")
    private String childNo;


    private Integer runningWaterType;

    @ExcelProperty("流水类型")
    private String runningWaterTypeMsg;

    public String getRunningWaterTypeMsg(){
        return OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.getMsgByCode(runningWaterType);
    }

    @ExcelProperty("金额")
    private BigDecimal alterationBalance;

    public BigDecimal getAlterationBalance(){
        return Objects.isNull(alterationBalance)? null : alterationBalance.movePointLeft(2);
    }


    @ExcelProperty("账户余额")
    private BigDecimal accountBalance;

    public BigDecimal getAccountBalance(){
        return Objects.isNull(accountBalance)? null : accountBalance.movePointLeft(2);
    }

    @ExcelProperty("操作人")
    private String createBy;

    @ExcelProperty("操作时间")
    private LocalDateTime createTime;


}
