package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanRecordDao;
import com.clx.performance.mapper.loan.OwnerLoanRecordMapper;
import com.clx.performance.model.loan.OwnerLoanRecord;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerLoanRecordParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanRecordOfOwner;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
@Repository
public class OwnerLoanRecordDaoImpl extends BaseDaoImpl<OwnerLoanRecordMapper, OwnerLoanRecord, Integer> implements OwnerLoanRecordDao {
    @Override
    public IPage<OwnerLoanRecord> pageOwnerLoanRecord(PageCarrierOwnerLoanRecordParam param) {
        LambdaQueryWrapper<OwnerLoanRecord> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getLoanType())){
            query.eq(OwnerLoanRecord :: getLoanType,param.getLoanType());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserNo())){
            query.eq(OwnerLoanRecord :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserName())){
            query.like(OwnerLoanRecord :: getOwnerUserName,param.getOwnerUserName());
        }
        if(StringUtils.isNotBlank(param.getMobile())){
            query.like(OwnerLoanRecord :: getMobile,param.getMobile());
        }
        if(Objects.nonNull(param.getLoanNo())){
            query.like(OwnerLoanRecord :: getLoanNo,param.getLoanNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.like(OwnerLoanRecord :: getStatus,param.getStatus());
        }
        query.orderByDesc(OwnerLoanRecord :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public IPage<OwnerLoanRecordVO> pageByParam(PageOwnerLoanRecordOfOwner param) {
        Page<OwnerLoanRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
