package com.clx.performance.controller.pc.loan.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageOwnerRepaymentOfOwner;
import com.clx.performance.param.pc.loan.owner.ExportPaymentApplicationFormParam;
import com.clx.performance.service.loan.OwnerRepaymentService;
import com.clx.performance.vo.pc.loan.carrier.OwnerRepaymentVO;
import com.clx.performance.vo.pc.loan.owner.CashierInfoVO;
import com.clx.performance.vo.pc.loan.owner.OrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.owner.TransferPaymentDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/owner/ownerRepayment")
@Validated
@Api(tags = "货主端-货主借款账户管理（申请借款）")
@AllArgsConstructor
public class OwnerRepaymentController {

    private final OwnerRepaymentService ownerRepaymentService;


    @ApiOperation(value = "还款列表",notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerRepayment")
    @UnitCovert(param = false)
    public Result<PageData<OwnerRepaymentVO>> pageOwnerRepayment(@RequestBody @Validated PageOwnerRepaymentOfOwner param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(String.valueOf(loginUserInfo.getUserNo()));
        IPage<OwnerRepaymentVO> page = ownerRepaymentService.pageOwnerRepaymentOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "收银台信息",notes = "<br>By:刘海泉")
    @GetMapping("/getCashierInfo")
    @UnitCovert(param = false)
    public Result<CashierInfoVO> getCashierInfo(@Param("id") @NotNull(message = "id不能为空") Integer id) {
        CashierInfoVO vo = ownerRepaymentService.getCashierInfo(id);
        return Result.ok(vo);
    }


    @ApiOperation(value = "订单支付详情",notes = "<br>By:刘海泉")
    @GetMapping("/getOrderPaymentDetail")
    @UnitCovert(param = false)
    public Result<OrderPaymentDetailVO> getOrderPaymentDetail(@Param("id") @NotNull(message = "id不能为空") Integer id) {
        OrderPaymentDetailVO vo = ownerRepaymentService.getOrderPaymentDetail(id);
        return Result.ok(vo);
    }

    @ApiOperation(value = "转账支付详情",notes = "<br>By:刘海泉")
    @GetMapping("/getTransferPaymentDetail")
    @UnitCovert(param = false)
    public Result<TransferPaymentDetailVO> getTransferPaymentDetail(@Param("id") @NotNull(message = "id不能为空") Integer id) {
        TransferPaymentDetailVO vo = ownerRepaymentService.getTransferPaymentDetail(id);
        return Result.ok(vo);
    }


    @ApiOperation(value = "生成付款申请单",notes = "<br>By:刘海泉")
    @GetMapping("/savePaymentApplicationForm")
    public Result<String> savePaymentApplicationForm(@RequestBody @Validated ExportPaymentApplicationFormParam param) {
        String url = ownerRepaymentService.savePaymentApplicationForm(param);
        return Result.ok(url);
    }





}
