package com.clx.performance.config.loan;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

/**
 * @ClassName ThirdAppConfig
 * @Description
 * @Author kavin
 * @Date 2023/10/18 19:18
 * @Version 1.0
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "clx" ) // 配置 文件的前缀
public class ClxPayeeConfig {

    //鑫祥和网络科技有限公司 配置ID
    public static final String XXH_ID = "1";


    // 这里的名字要和yml中的对应字段名称一致
    private static Map<String,PayeeConfig> payeeMap = new TreeMap<>();

    public static List<PayeeConfig> payeeList = new ArrayList<>();

    // 注意此处的 static 关键字
    public static PayeeConfig getPayeeMap(String id) {
        return payeeMap.get(id);
    }

    public void setPayeeMap(List<PayeeConfig> payeeConfigs) {
        payeeList = payeeConfigs;
        payeeMap = payeeConfigs.stream().collect(Collectors.toMap(PayeeConfig::getId,value -> value));
    }

    @Data
    public static class PayeeConfig {
        private String name;
        private String account;
        private String bank;
        private String bankNo;
        private String id;
    }


}
