package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;



@ApiModel(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierOrderChildDetailVO {


    @ApiModelProperty(value = "运单编号", example = "100000000")
    private String childNo;

    @ApiModelProperty(value = "货单编号", example = "100000000")
    private String orderGoodsNo;

    @ApiModelProperty(value = "货物名称", example = "煤")
    private String goodsName;

    @ApiModelProperty(value = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @ApiModelProperty(value = "应付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal payableFreight;

    @ApiModelProperty(value = "亏吨扣款（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossDeduction;

    @ApiModelProperty(value = "实付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal realFreight;

    @ApiModelProperty(value = "损耗单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;

    @ApiModelProperty(value = "订单运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal orderFreightPrice;

    @ApiModelProperty("货物重量")
    private BigDecimal extractWeight;

    @ApiModelProperty(value = "发货地址", example = "朝阳")
    private String sendAddress;

    @ApiModelProperty(value = "收货地址", example = "西城")
    private String receiveAddress;

    @ApiModelProperty(value = "车牌号", example = "京A12345")
    private String truckNo;

    @ApiModelProperty(value = "司机姓名", example = "张三")
    private String driverName;

    @ApiModelProperty(value = "司机手机号", example = "130000000")
    private String driverMobile;

    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;

    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @ApiModelProperty(value = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @ApiModelProperty(value="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @ApiModelProperty(value="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @ApiModelProperty(value = "取消原因", example = "取消原因类型：1个人原因, 2价格不合适, 3无法装货, 4车辆原因, 5交通管制, 6交通事故, 7无法找到地址, 8排队时间较长, 9其他原因")
    private Integer cancelType;
    @ApiModelProperty(value = "取消原因", example = "抢错了")
    private String cancelRemark;
    @ApiModelProperty(value = "司机取消详细原因", example = "司机取消详细原因")
    private String cancelDetail;

    @ApiModelProperty(value = "状态", example = "0")
    private Integer status;

    @ApiModelProperty(value = "装车磅单图片列表")
    private List<String> loadImageList;

    @ApiModelProperty(value = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @ApiModelProperty(value = "流程节点")
    private List<OrderChildLogVO> childLogs;

    @ApiModelProperty(value = "磅单审核列表")
    private List<OrderChildPoundAuditDetailVO> poundAudits;

    @ApiModelProperty(value = "完成时间", example = "2020-01-01 10:10:10")
    private String finishTime;


}