package com.clx.performance.param.pc.loan.owner;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class OwnerLoanRecordParam {

    @ApiModelProperty(value = "借款金额", example = "张三")
    @NotNull(message = "借款金额不能为空")
    @MoneyInConvert
    private BigDecimal loanBalance;

    @ApiModelProperty(value = "借款方", example = "伟华煤炭运销公司")
    @NotBlank(message = "借款方不能为空")
    private String borrower;


    @ApiModelProperty(value = "借出方", example = "诚联信网络科技有限公司")
    @NotBlank(message = "借出方不能为空")
    private String lendingParty;

    @ApiModelProperty(value = "借出方账户", example = "诚联信银行账户")
    @NotBlank(message = "借出方不能为空")
    private String lendingPartyAccount;

    @ApiModelProperty(value = "借出时效（天）", example = "2")
    @NotNull(message = "借出时效（天）不能为空")
    private Integer expireDay;
}
