package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OwnerLoanRecordEnum {
    ;

    //“待审批”，“审批通过”，“审批拒绝”，“付款中”，“付款成功”，“付款失败”
    @Getter
    @AllArgsConstructor
    public enum Status {
        APPROVE_WAIT(10, "待审批"),
        APPROVE_PASS(20, "审批通过"),
        APPROVE_REFUSE(30, "审批拒绝"),
        PAYING(40, "付款中"),
        PAY_SUCCESS(50, "付款成功"),
        PAY_FAIL(60, "付款失败"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    //1:虚拟货币  2:资金
    @Getter
    @AllArgsConstructor
    public enum LoanType {
        VIRTUAL_CURRENCY(1, "虚拟货币"),
        FUND(2, "资金"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<LoanType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(LoanType::getMsg).orElse(null);
        }
    }

}
