package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BorrowerConfigEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        ENABLE(1, "启用"),
        DISABLE(2, "禁用"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum DeleteStatus {
        NO(0, "否"),
        YES(1, "是"),

        ;

        private final Integer code;
        private final String msg;

    }


    @Getter
    @AllArgsConstructor
    public enum Type {
        NO(0, "否"),
        YES(1, "是"),

        ;

        private final Integer code;
        private final String msg;

    }

}
