/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.DSA;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.digests.RIPEMD160Digest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.digests.SHA224Digest;
import cn.com.infosec.crypto.digests.SHA256Digest;
import cn.com.infosec.crypto.digests.SHA384Digest;
import cn.com.infosec.crypto.digests.SHA512Digest;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.signers.DSASigner;
import cn.com.infosec.crypto.signers.ECDSASigner;
import cn.com.infosec.crypto.signers.ECNRSigner;
import cn.com.infosec.jce.interfaces.ECKey;
import cn.com.infosec.jce.interfaces.ECPublicKey;
import cn.com.infosec.jce.interfaces.GOST3410Key;
import cn.com.infosec.jce.provider.DSAUtil;
import cn.com.infosec.jce.provider.ECUtil;
import cn.com.infosec.jce.provider.GOST3410Util;
import cn.com.infosec.jce.provider.JDKKeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;

public class JDKDSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected JDKDSASigner(Digest digest, DSA signer) {
        this.digest = digest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        block10: {
            if (publicKey instanceof ECPublicKey) {
                param = ECUtil.generatePublicKeyParameter(publicKey);
            } else if (publicKey instanceof GOST3410Key) {
                param = GOST3410Util.generatePublicKeyParameter(publicKey);
            } else if (publicKey instanceof DSAKey) {
                param = DSAUtil.generatePublicKeyParameter(publicKey);
            } else {
                try {
                    byte[] bytes = publicKey.getEncoded();
                    publicKey = JDKKeyFactory.createPublicKeyFromDERStream(bytes);
                    if (publicKey instanceof ECPublicKey) {
                        param = ECUtil.generatePublicKeyParameter(publicKey);
                        break block10;
                    }
                    if (publicKey instanceof DSAKey) {
                        param = DSAUtil.generatePublicKeyParameter(publicKey);
                        break block10;
                    }
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                catch (Exception e) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
            }
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = privateKey instanceof ECKey ? ECUtil.generatePrivateKeyParameter(privateKey) : (privateKey instanceof GOST3410Key ? GOST3410Util.generatePrivateKeyParameter(privateKey) : DSAUtil.generatePrivateKeyParameter(privateKey));
        this.digest.reset();
        if (this.random != null) {
            this.signer.init(true, new ParametersWithRandom(param, this.random));
        } else {
            this.signer.init(true, param);
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.signer.generateSignature(hash);
            return this.derEncode(sig[0], sig[1]);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.derDecode(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(r));
        v.add(new DERInteger(s));
        dOut.writeObject(new DERSequence(v));
        return bOut.toByteArray();
    }

    private BigInteger[] derDecode(byte[] encoding) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        ASN1Sequence s = (ASN1Sequence)aIn.readObject();
        BigInteger[] sig = new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
        return sig;
    }

    private static class NullDigest
    implements Digest {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private NullDigest() {
        }

        public String getAlgorithmName() {
            return "NULL";
        }

        public int getDigestSize() {
            return this.bOut.size();
        }

        public void update(byte in) {
            this.bOut.write(in);
        }

        public void update(byte[] in, int inOff, int len) {
            this.bOut.write(in, inOff, len);
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] res = this.bOut.toByteArray();
            System.arraycopy(res, 0, out, outOff, res.length);
            return res.length;
        }

        public void reset() {
            this.bOut.reset();
        }
    }

    public static class dsa224
    extends JDKDSASigner {
        public dsa224() {
            super(new SHA224Digest(), new DSASigner());
        }
    }

    public static class dsa256
    extends JDKDSASigner {
        public dsa256() {
            super(new SHA256Digest(), new DSASigner());
        }
    }

    public static class dsa384
    extends JDKDSASigner {
        public dsa384() {
            super(new SHA384Digest(), new DSASigner());
        }
    }

    public static class dsa512
    extends JDKDSASigner {
        public dsa512() {
            super(new SHA512Digest(), new DSASigner());
        }
    }

    public static class ecDSA
    extends JDKDSASigner {
        public ecDSA() {
            super(new SHA1Digest(), new ECDSASigner());
        }
    }

    public static class ecDSA224
    extends JDKDSASigner {
        public ecDSA224() {
            super(new SHA224Digest(), new ECDSASigner());
        }
    }

    public static class ecDSA256
    extends JDKDSASigner {
        public ecDSA256() {
            super(new SHA256Digest(), new ECDSASigner());
        }
    }

    public static class ecDSA384
    extends JDKDSASigner {
        public ecDSA384() {
            super(new SHA384Digest(), new ECDSASigner());
        }
    }

    public static class ecDSA512
    extends JDKDSASigner {
        public ecDSA512() {
            super(new SHA512Digest(), new ECDSASigner());
        }
    }

    public static class ecDSARipeMD160
    extends JDKDSASigner {
        public ecDSARipeMD160() {
            super(new RIPEMD160Digest(), new ECDSASigner());
        }
    }

    public static class ecNR
    extends JDKDSASigner {
        public ecNR() {
            super(new SHA1Digest(), new ECNRSigner());
        }
    }

    public static class ecNR224
    extends JDKDSASigner {
        public ecNR224() {
            super(new SHA224Digest(), new ECNRSigner());
        }
    }

    public static class ecNR256
    extends JDKDSASigner {
        public ecNR256() {
            super(new SHA256Digest(), new ECNRSigner());
        }
    }

    public static class ecNR384
    extends JDKDSASigner {
        public ecNR384() {
            super(new SHA384Digest(), new ECNRSigner());
        }
    }

    public static class ecNR512
    extends JDKDSASigner {
        public ecNR512() {
            super(new SHA512Digest(), new ECNRSigner());
        }
    }

    public static class noneDSA
    extends JDKDSASigner {
        public noneDSA() {
            super(new NullDigest(), new DSASigner());
        }
    }

    public static class stdDSA
    extends JDKDSASigner {
        public stdDSA() {
            super(new SHA1Digest(), new DSASigner());
        }
    }
}

