/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.nist;

import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.sec.SECNamedCurves;
import cn.com.infosec.asn1.sec.SECObjectIdentifiers;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

public class NISTNamedCurves {
    static final Hashtable objIds = new Hashtable();
    static final Hashtable names = new Hashtable();

    static {
        NISTNamedCurves.defineCurve("B-571", SECObjectIdentifiers.sect571r1);
        NISTNamedCurves.defineCurve("B-409", SECObjectIdentifiers.sect409r1);
        NISTNamedCurves.defineCurve("B-283", SECObjectIdentifiers.sect283r1);
        NISTNamedCurves.defineCurve("B-233", SECObjectIdentifiers.sect233r1);
        NISTNamedCurves.defineCurve("B-163", SECObjectIdentifiers.sect163r2);
        NISTNamedCurves.defineCurve("P-521", SECObjectIdentifiers.secp521r1);
        NISTNamedCurves.defineCurve("P-256", SECObjectIdentifiers.secp256r1);
        NISTNamedCurves.defineCurve("P-224", SECObjectIdentifiers.secp224r1);
        NISTNamedCurves.defineCurve("P-384", SECObjectIdentifiers.secp384r1);
    }

    static void defineCurve(String name, DERObjectIdentifier oid) {
        objIds.put(name, oid);
        names.put(oid, name);
    }

    public static X9ECParameters getByName(String name) {
        DERObjectIdentifier oid = (DERObjectIdentifier)objIds.get(Strings.toUpperCase(name));
        if (oid != null) {
            return NISTNamedCurves.getByOID(oid);
        }
        return null;
    }

    public static X9ECParameters getByOID(DERObjectIdentifier oid) {
        return SECNamedCurves.getByOID(oid);
    }

    public static DERObjectIdentifier getOID(String name) {
        return (DERObjectIdentifier)objIds.get(Strings.toUpperCase(name));
    }

    public static String getName(DERObjectIdentifier oid) {
        return (String)names.get(oid);
    }

    public static Enumeration getNames() {
        return objIds.keys();
    }
}

