package com.clx.performance.vo.pc.loan.owner;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName CashierInfoVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:24
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OwnerCashierInfoVO {

    @Schema(description="还款单号")
    private Long repaymentNo;

    @Schema(description="货物名称")
    private String goodsName;


    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @MoneyOutConvert
    @Schema(description="订单金额")
    private BigDecimal repaymentBalance;

    @Schema(description="是否有订单支付方式 true:有  false:没有")
    private Boolean orderPayWay;


    @Schema(description="付款账户")
    private String payAccount;

    @Schema(description="银行名称")
    private String bankName;

}
