package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.enums.loan.OwnerLoanAccountApproveEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
public class OwnerLoanAccountApproveVO {

    private Integer id;

    
    @Schema(description="货主编码")
    private String ownerUserNo;

    
    @Schema(description="货主名称")
    private String ownerUserName;

    
    @Schema(description="联系电话")
    private String mobile;

    
    @Schema(description="账户类型 默认3 借款账户")
    private String accountType;

    public String getAccountType(){
        return OwnerAccountEnum.AccountTypeStatus.LOAN_ACCOUNT.getMsg();
    }


    
    @Schema(description="待审批 10，审批成功 20，审批拒绝 30")
    private Integer status;


    @Schema(description="待审批 审批成功 审批拒绝 ")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanAccountApproveEnum.Status.getMsgByCode(status);
    }

    
    @Schema(description="审批时间")
    private String approveTime;

    
    @Schema(description="审批人")
    private String approveBy;

    
    @Schema(description="拒绝原因")
    private String rejectReason;

    
    @Schema(description="创建人")
    private String createBy;

    
    @Schema(description="创建时间")
    private String createTime;

    
    @Schema(description="修改时间")
    private String modifiedTime;

}
