package com.clx.performance.vo.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRecordVO {

    @Schema(description="id")
    private Integer id;

    @Schema(description="触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @Schema(description="违约方类型：1平台 2货主 3司机")
    private Integer breakContractPartyType;

    @Schema(description="违约订单")
    private String orderNo;

    @Schema(description="违约金（分）")
    @MoneyOutConvert
    private BigDecimal figure;

    @Schema(description="结算单编号")
    private String settlementNo;

    @Schema(description="备注")
    private String remark;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="确认状态：0-确认中;1-已经确认;2-已驳回")
    private Integer confirmStatus;

    @Schema(description="驳回原因")
    private String rejectReason;

}
