package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.poi.hpsf.Decimal;

import java.math.BigDecimal;
import java.time.LocalDateTime;


@Getter
@Setter
@NoArgsConstructor
public class OwnerAccountVO {

    @Schema(description = "id")
    private Integer id;
    /**
     * 货主编码
     */
    @Schema(description = "货主编码")
    private String ownerUserNo;
    /**
     * 货主名称
     */
    @Schema(description = "货主名称")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @Schema(description = "联系电话")
    private String mobile;
    /**
     * 账户类型;1:保证金 2：预付运费
     */
    @Schema(description = "账户类型;1:保证金 2：预付运费")
    private Integer accountType;
    /**
     * 账户余额
     */
    @Schema(description = "账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;
    /**
     * 可用余额
     */
    @Schema(description = "可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;
    /**
     * 冻结金额
     */
    @Schema(description = "冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    /**
     * 创建人
     */
    @Schema(description = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private String createTime;

    @Schema(description = "修改时间")
    private String modifiedTime;

}