package com.clx.performance.vo.pc;

import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;



@Schema(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierOrderChildDetailVO {


    @Schema(description = "订单编号", example = "100000000")
    private String orderNo;
    @Schema(description = "运单编号", example = "100000000")
    private String childNo;

    @Schema(description = "货单编号", example = "100000000")
    private String orderGoodsNo;

    @Schema(description = "货物名称", example = "煤")
    private String goodsName;

    @Schema(description = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @Schema(description = "应付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal payableFreight;

    @Schema(description = "亏吨扣款（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossDeduction;

    @Schema(description = "实付运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal realFreight;

    @Schema(description = "损耗单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;

    @Schema(description = "订单运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal orderFreightPrice;

    @Schema(description="货物重量")
    private BigDecimal extractWeight;

    @Schema(description = "发货地址", example = "朝阳")
    private String sendAddress;

    @Schema(description = "收货地址", example = "西城")
    private String receiveAddress;

    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;

    @Schema(description = "司机姓名", example = "张三")
    private String driverName;

    @Schema(description = "司机手机号", example = "130000000")
    private String driverMobile;

    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;

    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @Schema(description = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @Schema(description = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @Schema(description="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @Schema(description="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @Schema(description = "取消原因", example = "取消原因类型：1个人原因, 2价格不合适, 3无法装货, 4车辆原因, 5交通管制, 6交通事故, 7无法找到地址, 8排队时间较长, 9其他原因")
    private Integer cancelType;
    @Schema(description = "取消原因", example = "抢错了")
    private String cancelRemark;
    @Schema(description = "司机取消详细原因", example = "司机取消详细原因")
    private String cancelDetail;

    @Schema(description = "状态", example = "0")
    private Integer status;

    @Schema(description = "装车磅单图片列表")
    private List<String> loadImageList;

    @Schema(description = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @Schema(description = "流程节点")
    private List<OrderChildLogVO> childLogs;

    @Schema(description = "磅单审核列表")
    private List<OrderChildPoundAuditDetailVO> poundAudits;

    @Schema(description = "完成时间", example = "2020-01-01 10:10:10")
    private String finishTime;

    @Schema(description = "接单时间", example = "2020-01-01 10:10:10")
    private String createTime;

    @Schema(description = "取消时间", example = "2020-01-01 10:10:10")
    private String cancelTime;

    @Schema(description = "收货待确认时间", example = "2020-01-01 10:10:10")
    private String unloadTime;

    @Schema(description = "货源地详细地址")
    private String sendDetailAddress;

    @Schema(description = "目的地详细地址")
    private String receiveDetailAddress;

    @Schema(description = "订单来源")
    private Integer orderSource;
    private String orderSourceMsg;
    public String getOrderSourceMsg() {
        return SyncPlatformEnum.Source.getNameByCode(orderSource);
    }
}