package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName PageCarrierSettlementOwnerParam
 * @Description
 * @Author kavin
 * @Date 2023/10/17 13:25
 * @Version 1.0
 */
@Getter
@Setter
public class PageCarrierSettlementOwnerParam extends PageParam {

    @Schema(description = "结算编号", example = "JS415")
    private String settlementNo;

    @Schema(description="货主编码",example = "201457878")
    private Long ownerUserNo;

    @Schema(description="状态 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结",example = "10")
    private String status;

    @Schema(description="货主姓名",example = "张三")
    private String ownerUserName;

    @Schema(description="结算方式  1装车净重 2卸车净重 3卸车净重（减货损）")
    private Integer settlementWay;


    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description = "开始时间")
    private String beginTime;

    @Schema(description = "结束时间")
    private String endTime;
}
