package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectWaitReportReceiveAddressSaveParam {

    @Schema(description = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "排队状态：1 无需排队 2 场内需要排队 3 厂外需要排队", example = "1")
    @NotNull(message = "排队状态不能为空")
    private Integer waitType;

    @Schema(description = "预计等待时长", example = "1")
    private BigDecimal stationTime;
    @Schema(description = "图片列表")
    private List<String> stationImageList;

}
