package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.order.param.mq.SyncPendingFreightInternalReportParam;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.service.PendingFreightService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
@AllArgsConstructor
public class SyncPendingFreight4InternalReportListener {


    private final PendingFreightService pendingFreightService;

    @RabbitListener(queues = RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_INTERNAL_REPORT_QUEUE)
    public void onMessage(Message message) {
        try{
            log.info("监听到同步挂单运费表---内部上报信息部分,消息内容{}", new String(message.getBody()));
            SyncPendingFreightInternalReportParam data = JSON.parseObject(new String(message.getBody()),
                    new TypeReference<MqWrapper<SyncPendingFreightInternalReportParam>>() {
                    }).getData();
            pendingFreightService.dealPendingFreight4InternalReport(data);


        }catch (Exception e){
            log.info("监听到同步挂单运费表---内部上报信息部分发生异常，异常原因：{}", ExceptionUtils.getStackTrace(e));
        }
    }
}
