package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PagePendingFreightParam;
import com.msl.common.dao.BaseDao;
import com.clx.performance.mapper.PendingFreightMapper;
import com.clx.performance.model.PendingFreight;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 19:37
 */
public interface PendingFreightDao extends BaseDao<PendingFreightMapper, PendingFreight, Integer> {
    long updateInternalReportData(String orderNo, String name, BigDecimal logisticsFreight);

    void updateOrderedAndLoadTruckRate(String orderNo, BigDecimal orderedRate, BigDecimal loadTruckRate);

    IPage<PendingFreight> pagePendingFreight(PagePendingFreightParam param);

    void updatePendingFreight(String orderNo, BigDecimal pendingFreight, BigDecimal avgPendingFreight);
}
