package com.clx.performance.controller.pc.vehiclewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.*;
import com.clx.performance.service.vehiclewarn.VehicleWarnConfigService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnConfigVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;
import java.util.List;


@Slf4j
@RestController
@Validated
@Tag(name = "车辆预警-预警配置")
@RequestMapping(value="/pc/owner/vehicleWarnConfig")
public class VehicleWarnConfigController {

    @Autowired
    private VehicleWarnConfigService vehicleWarnConfigService;

    @Operation(summary = "新增配置", description = "<br>By:艾庆国")
    @PostMapping("/saveConfig")
    @UnitCovert(result = false)
    public Result<Void> saveConfig(@RequestBody @Validated VehicleWarnConfigAddParam param) {

        vehicleWarnConfigService.saveConfig(param);

        return Result.ok();
    }

    @Operation(summary = "更新配置", description = "<br>By:艾庆国")
    @PostMapping("/updateConfig")
    public Result<Void> updateConfig(@RequestBody @Validated VehicleWarnConfigUpdateParam param) {
        vehicleWarnConfigService.updateConfig(param);
        return Result.ok();
    }

    @Operation(summary = "更新配置状态", description = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated VehicleWarnConfigStatusUpdateParam param) {

        vehicleWarnConfigService.updateStatus(param);
        return Result.ok();
    }

    @Operation(summary = "删除配置", description = "<br>By:艾庆国")
    @PostMapping("/deleteConfig")
    public Result<Void> deleteConfig(@RequestBody @Validated VehicleWarnConfigDeleteUpdateParam param) {
        vehicleWarnConfigService.deleteConfig(param);
        return Result.ok();
    }

    @Operation(summary = "获取配置信息",description = "<br>By:艾庆国")
    @GetMapping("/getConfig")
    public Result<VehicleWarnConfigVO> getConfig(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnConfigService.getConfig(id));
    }

    @Operation(summary = "分页搜索配置列表",description = "<br>By:艾庆国")
    @PostMapping("/pageConfig")
    public Result<PageData<VehicleWarnConfigVO>> pageConfig(@RequestBody @Validated PageVehicleWarnConfigParam param) {
        IPage<VehicleWarnConfigVO> page = vehicleWarnConfigService.pageConfig(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "预警类型下拉",description = "<br>By:艾庆国")
    @GetMapping("/listWarnType")
    public Result<List<VehicleWarnConfigVO.WarnTypeItem>> listWarnType() {
        return Result.ok(vehicleWarnConfigService.listWarnType());
    }

}
