package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRecordAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRecordParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/ownerRecord")
@Validated
@Tag(name = "承运端-货主违约管理")
@AllArgsConstructor
public class CarrierBreakContractOwnerRecordController {

    private final BreakContractOwnerRecordService breakContractOwnerRecordService;


    @Operation(summary = "新增违约记录", description = "<br>By:艾庆国")
    @PostMapping("/saveRecord")
    @UnitCovert
    public Result<Void> saveRecord(@RequestBody @Validated BreakContractOwnerRecordAddParam param) {
        breakContractOwnerRecordService.saveRecord(param);

        return Result.ok();
    }

    @Operation(summary = "分页搜索违约列表",description = "<br>By:艾庆国")
    @PostMapping("/pageRecord")
    @UnitCovert(param = false)
    public Result<PageData<BreakContractOwnerRecordVO>> pageRecord(@RequestBody @Validated PageBreakContractOwnerRecordParam param) {
        IPage<BreakContractOwnerRecordVO> page = breakContractOwnerRecordService.pageRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
