package com.clx.performance.controller.feign;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.feign.CancelOrderGoodsParam;
import com.clx.performance.service.LastTruckService;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderChild")
@Validated
@Tag(name = "运单Feign")
@AllArgsConstructor
public class OrderChildFeignController {

    private final OrderChildService orderChildService;

    private final FeignOrderChildService feignOrderChildService;

    private final LastTruckService lastTruckService;

    private final SettlementOwnerDetailService settlementOwnerDetailService;


    @GetMapping({"/getOrderChildTotalByUserNo"})
    Integer getTrucksByOrderGoodsNo(@RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo) {
        Integer totalByUserNo = orderChildService.getOrderChildTotalByUserNo(userNo);
        return totalByUserNo;
    }

    /**
     * 查询在途运单
     *
     * @param orderNo
     * @return
     */
    @GetMapping({"/selectInTransitOrderChild"})
    Result<Boolean> selectInTransitOrderChild(@RequestParam("orderNo") String orderNo) {
        List<OrderChild> orderChildren = orderChildService.selectInTransitOrderChild(orderNo);
        if (CollectionUtil.isNotEmpty(orderChildren)) {
            return Result.ok(true);
        } else {
            return Result.ok(false);
        }
    }

    @GetMapping({"/selectInTransitOrderChildLtUnsettle"})
    Result<Boolean> selectInTransitOrderChildLtUnsettle(@RequestParam("orderNo") String orderNo) {
        List<OrderChild> orderChildren = orderChildService.selectInTransitOrderChildLtUnsettle(orderNo);
        if (CollectionUtil.isNotEmpty(orderChildren)) {
            return Result.ok(true);
        } else {
            return Result.ok(false);
        }
    }

    @Operation(summary = "线路运单统计", description = "<br>By:艾庆国")
    @RequestMapping(value = "/lineStatistics", method = RequestMethod.GET)
    Result<OrderChildLineStatisticsVO> lineStatistics(@RequestParam @NotNull(message = "发货地址不可为空") Integer sendSystemAddressId,
                                                      @RequestParam @NotNull(message = "收货货地不可为空") Integer receiveSystemAddressId){

        return Result.ok(feignOrderChildService.getLineStatistics(sendSystemAddressId, receiveSystemAddressId));

    }

    @Operation(summary = "订单取消/到达最晚拉运时间同步最后一车", description = "<br>By:刘海泉")
    @RequestMapping(value = "/syncLastTruck", method = RequestMethod.GET)
    Result<?> syncLastTruck(@RequestParam("orderNo") @NotBlank(message = "订单编号不能为空") String orderNo){
        return lastTruckService.syncLastTruckChild4OrderTrigger(orderNo);

    }

    @Operation(summary = "获取当前订单是否有存在网运单", description = "<br>By:胡宇帆")
    @GetMapping({"/getInvoiceType"})
    Result<Integer> getInvoiceType(@RequestParam("orderNo") @NotNull(message = "订单编号不能为空") String orderNo) {
        return Result.ok(settlementOwnerDetailService.getInvoiceType(orderNo));
    }

    @Operation(summary = "取消运单", description = "<br>By:李瑞新")
    @PostMapping({"/cancelOrderChild"})
    Result<Object> cancelOrderChild(@RequestBody @Validated CancelOrderGoodsParam param) {
        orderChildService.cancelOrderChilds(param);
        return Result.ok();
    }

}
