package com.clx.performance.service.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dto.LoanBalanceDTO;
import com.clx.performance.param.pc.loan.carrier.*;
import com.clx.performance.param.pc.loan.owner.ExportPaymentApplicationFormParam;
import com.clx.performance.param.pc.loan.owner.OwnerLoanRecordParam;
import com.clx.performance.vo.pc.loan.carrier.CarrierCashierInfoVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierTransferPaymentDetailVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerOrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.owner.OwnerLoanRecordDetail;



/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
public interface OwnerLoanRecordService {
    IPage<OwnerLoanRecordVO> pageOwnerLoanRecord(PageCarrierOwnerLoanRecordParam param);

    void ownerLoanRecordSubmit(OwnerLoanRecordParam param);

    void ownerLoanRecordApprove(CarrierOwnerLoanRecordApproveParam param);

    IPage<OwnerLoanRecordVO> pageOwnerLoanRecordOfOwner(PageOwnerLoanRecordOfOwner param);

    OwnerLoanRecordDetail getOwnerLoanRecordDetail();

    CarrierCashierInfoVO getCashierInfo(Integer id);

    CarrierOwnerOrderPaymentDetailVO getOrderPaymentDetail(Integer id);

    CarrierTransferPaymentDetailVO getTransferPaymentDetail(Integer id);

    String savePaymentApplicationForm(ExportPaymentApplicationFormParam param);

    void getLoanBalance(LoanBalanceDTO param);
    void updateOwnerLoanRecordPay(CarrierOwnerLoanRecordPayParam param);
    void updateOwnerLoanRecordRepay(CarrierOwnerLoanRecordRepayParam param);
    void updateOwnerLoanRecordPayCancel(CarrierOwnerLoanRecordPayCancelParam param);

    void payFail(String merSeqNo);

    void paySuccess(String merSeqNo);

    void ownerLoanRecordRetryPay(String loanNo);

    void ownerLoanRecordCancelPay(String loanNo);

    String sendLoanSms(String mobile,Long loanNo);

    String sendOrderPaySms(String mobile,String payee, String payeeAccount);

    Integer ownerLoanRecordSubmitNbBank(CarrierOwnerLoanRecordApproveParam param);

    void orderChildLoanProcess(Long ownerUserNo);
}
