//package com.clx.performance.listener;
//
//import cn.hutool.json.JSONUtil;
//import com.clx.performance.component.OrderChildLoanComponent;
//import com.clx.performance.constant.RabbitKeyConstants;
//import com.clx.performance.dao.settle.SettlementDriverDetailDao;
//import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
//import com.clx.performance.dto.OwnerLoanMqDTO;
//import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
//import com.clx.performance.event.SettlementUpdateEvent;
//import com.clx.performance.model.OrderChild;
//import com.clx.performance.model.settle.SettlementDriverDetail;
//import com.clx.performance.model.settle.SettlementOwnerDetail;
//import com.clx.performance.service.settle.SettlementMqService;
//import lombok.AllArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.amqp.rabbit.annotation.RabbitListener;
//import org.springframework.context.ApplicationEventPublisher;
//import org.springframework.stereotype.Component;
//import org.springframework.transaction.PlatformTransactionManager;
//import org.springframework.transaction.TransactionDefinition;
//import org.springframework.transaction.TransactionStatus;
//
///**
// * 处理货主借款监听器
// */
//@Slf4j
//@Component
//@AllArgsConstructor
//public class OwnerLoanListener {
//
//    private final OrderChildLoanComponent orderChildLoanComponent;
//
//    private final SettlementMqService settlementMqService;
//
//    private final ApplicationEventPublisher applicationEventPublisher;
//
//    private final SettlementOwnerDetailDao settlementOwnerDetailDao;
//
//    private final SettlementDriverDetailDao settlementDriverDetailDao;
//
//    private final PlatformTransactionManager platformTransactionManager;
//
//    private final TransactionDefinition transactionDefinition;
//
//    @RabbitListener(queues = RabbitKeyConstants.OWNER_LOAN_QUEUE)
//    public void onMessage(String message) {
//        TransactionStatus transactionStatus = platformTransactionManager.getTransaction(transactionDefinition);
//
//        log.info("处理货主借款监听器执行,数据为{}", message);
//        OwnerLoanMqDTO param = JSONUtil.toBean(message, OwnerLoanMqDTO.class);
//        SettlementOwnerDetail settlementOwnerDetail = param.getSettlementOwnerDetail();
//        SettlementDriverDetail settlementDriverDetail = param.getSettlementDriverDetail();
//        OrderChild orderChild = param.getOrderChild();
//
//        try {
//            //生成借款标识
//            orderChildLoanComponent.childLoanConfirmAfterProcess(settlementDriverDetail, settlementOwnerDetail, orderChild);
//        } catch (Exception e) {
//            //未借款
//            settlementDriverDetail.setLoanFlag(OwnerLoanRecordEnum.LoanFlag.NO_LOAN.getCode());
//            applicationEventPublisher.publishEvent(new SettlementUpdateEvent(this, settlementDriverDetail, settlementOwnerDetail));
//            log.error("处理货主借款监听器执行异常,数据为{}", message, e);
//            platformTransactionManager.commit(transactionStatus);
//
//            return;
//        }
//        log.info("处理货主借款监听器执行成功");
//        settlementOwnerDetailDao.updateInvoiceType(settlementOwnerDetail);
//        settlementDriverDetailDao.updateInvoiceTypeAndPrepayFreightFlag(settlementDriverDetail);
//
//        // 发送mq 通过开票标识
//        settlementMqService.invoiceTypeSync(settlementDriverDetail.getChildNo(), settlementDriverDetail.getInvoiceType());
//        platformTransactionManager.commit(transactionStatus);
//
//    }
//}
