/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;

public class TestSHZN {
    static {
        try {
            NetSignAgent.initialize("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestSHZN.testEncrypt();
        TestSHZN.testDecrypt();
    }

    public static void testEncrypt() {
        String plainFile = "D:\\temp\\1.pdf";
        String cipherFile = "D:\\temp\\1.pdf.cipher";
        String encCertID = "12345678";
        try {
            NetSignAgent.SHZNFileEncrypt(plainFile, cipherFile, encCertID);
            System.out.println("encrypt successed.");
        }
        catch (Exception e) {
            System.out.println("encrypt failed.");
            TestSHZN.handleException(e);
        }
    }

    public static void testDecrypt() {
        String plainFile = "D:\\temp\\2.pdf";
        String cipherFile = "D:\\temp\\1.pdf.cipher";
        try {
            NetSignAgent.SHZNFileDecrypt(cipherFile, plainFile);
            System.out.println("decrypt successed.");
        }
        catch (Exception e) {
            System.out.println("decrypt failed.");
            TestSHZN.handleException(e);
        }
    }

    private static void handleException(Exception e) {
        Exception se;
        if (e instanceof NetSignAgentException) {
            se = (NetSignAgentException)e;
            System.out.println("errorcode=" + ((NetSignAgentException)se).getErrorCode());
            System.out.println("errormsg=" + se.getMessage());
        }
        if (e instanceof ServerProcessException) {
            se = (ServerProcessException)e;
            System.out.println("errorcode=" + ((ServerProcessException)se).getErrorCode());
            System.out.println("errormsg=" + se.getMessage());
        }
    }

    private static void testParallel() {
        int tc = 8;
        TestSHZN test = new TestSHZN();
        int i = 0;
        while (i < tc) {
            Thread t = new Thread(test.getEncrypt(i));
            t.start();
            ++i;
        }
    }

    private Encrypt getEncrypt(int i) {
        return new Encrypt(i);
    }

    public class Encrypt
    implements Runnable {
        private int i;

        public Encrypt(int i) {
            this.i = i;
        }

        public void run() {
            String plainFile = "D:\\1.pdf";
            String cipherFile = "D:\\" + this.i + ".pdf.cipher";
            String encCertID = "CN=5year,O=syn080924,C=cn";
            try {
                NetSignAgent.SHZNFileEncrypt(plainFile, cipherFile, encCertID);
                System.out.println("encrypt successed.");
            }
            catch (Exception e) {
                System.out.println("encrypt failed.");
                TestSHZN.handleException(e);
            }
        }
    }
}

