/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.generators.DHKeyGeneratorHelper;
import cn.com.infosec.crypto.params.ElGamalKeyGenerationParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ElGamalParameters elParams = this.param.getParameters();
        BigInteger p = elParams.getP();
        BigInteger x = this.helper.calculatePrivate(p, this.param.getRandom(), elParams.getL());
        BigInteger y = this.helper.calculatePublic(p, elParams.getG(), x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, elParams), new ElGamalPrivateKeyParameters(x, elParams));
    }
}

